package pt.caf_pbs.schooldiskclient.ui;

import android.content.Intent;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.*;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import pt.caf_pbs.schooldiskclient.R;

import pt.caf_pbs.schooldiskclient.adapter.ListViewAdapterInstructor;
import pt.caf_pbs.schooldiskclient.adapter.ListViewAdapterSubject;

import pt.caf_pbs.schooldiskclient.helper.Utils;
import pt.caf_pbs.schooldiskclient.model.Instructor;
import pt.caf_pbs.schooldiskclient.model.Subject;
import pt.caf_pbs.schooldiskclient.service.RequestsService;

import java.util.ArrayList;
import java.util.List;

public class InstructorDetailActivity extends AppCompatActivity {

    private String initials;
    private String name;
    private TextView tvInitials, tvName;
    private ListView lv;
    private ProgressBar pdRing;
    private List<Subject> subjectsList;
    private ActivityResultLauncher<Intent> someActivityResultLauncher;
    private ListViewAdapterSubject adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_instructor_detail);

        pdRing = (ProgressBar) findViewById(R.id.progressBar);
        pdRing.setVisibility(ProgressBar.INVISIBLE);
        tvInitials = (TextView) findViewById(R.id.tvInitials);
        tvName = (TextView) findViewById(R.id.tvName);
        Intent intent = getIntent();
        initials = intent.getStringExtra(Utils.ID);
        name = intent.getStringExtra(Utils.NAME);;

        tvInitials.setText(initials);
        tvName.setText(name);

        lv = (ListView) findViewById(R.id.listView);
        subjectsList = new ArrayList();
        someActivityResultLauncher = registerForActivityResult(
                new ActivityResultContracts.StartActivityForResult(),
                new ActivityResultCallback<ActivityResult>() {
                    @Override
                    public void onActivityResult(ActivityResult result) {
                        if(result.getResultCode() == RESULT_OK){
                            getInstructorLecturesFromWs();
                        }
                    }
                });
        adapter = new ListViewAdapterSubject(this, subjectsList);
        lv.setAdapter(adapter);
        getInstructorLecturesFromWs();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.optionmenu_detail, menu);
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent;
        switch (item.getItemId()) {
            case R.id.add:
                intent = new Intent(this, SubjectsActivity.class);
                intent.putExtra(Utils.PICK, true);
                intent.putExtra(Utils.ID, initials);
                someActivityResultLauncher.launch(intent);
                return true;
            case R.id.settings:
                intent = new Intent(this, SettingsActivity.class);
                someActivityResultLauncher.launch(intent);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private void getInstructorLecturesFromWs() {
        new Thread() {
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.VISIBLE);
                    }
                });
                List<Subject> subjectsDTOS = RequestsService.getInstructorLectures(initials, InstructorDetailActivity.this);
                subjectsList.clear();
                subjectsList.addAll(subjectsDTOS);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        adapter.notifyDataSetChanged();
                        pdRing.setVisibility(ProgressBar.GONE);
                    }
                });
            }
        }.start();
    }
}
